﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.WF
{
    public class PatientMovementMap : EntityMap<PatientMovement>
    {
        public override PatientMovement NewEntity(string ien)
        {
            return new PatientMovement() { IEN = ien };
        }

        public override string File
        {
            get { return "405"; }
        }

        public override string Location
        {
            get { return "DGPM("; }
        }

        protected override void MapFields()
        {
            MapDateTime(".01", (m, s) => m.DateTime = s);
            MapDateTime("101", (m, s) => m.EnteredOnDateTime = s);            
            MapPointerToFile<NewPerson>("100", (m, s) => m.EnteredById = s, (m, s) => m.EnteredBy = s);
            MapPointerToFile(".02", (m, s) => m.TransactionTypeId = s);
            MapPointerToFile<Patient>(".03", (m, s) => m.PatientId = s, (m, s) => m.Patient = s);
            MapPointerToFile<FacilityMovementType>(".04", (m, s) => m.TypeOfMovementId = s, (m, s) => m.TypeOfMovement = s);
            MapPointerToFile(".06", (m, s) => m.WardLocationId = s);
            MapPointerToFile(".07", (m, s) => m.RoomBedId = s);
            MapPointerToFile(".14", (m, s) => m.CurrentAdmissionIen = s);
        }
    }
}
